<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CreatorStages
 *
 * @ORM\Table(name="creator_stages")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\CreatorStagesRepository")
 *
 * @ExclusionPolicy("all")
 */
class CreatorStages
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"list","partsList","details"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="symbol", type="string", length=30, unique=true)
     *
     * @Expose
     * @AnnotationGroups({"list","partsList","details"})
     */
    private $symbol;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"list","partsList","details"})
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="CreatorStagesParts", mappedBy="stage", cascade={"persist"})
     * @ORM\OrderBy({"index" = "ASC"})
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $parts;

    /**
     * @ORM\OneToMany(targetEntity="CreatorStagesSteps", mappedBy="stage", cascade={"persist"})
     * @ORM\OrderBy({"index" = "ASC"})
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $steps;

    /**
     * @ORM\OneToMany(targetEntity="CreatorStagesCompanyConfirm", mappedBy="stage")
     *
     * @Expose
     * @AnnotationGroups({""})
     */
    private $creatorStagesCompanyConfirms;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->parts = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return CreatorStages
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return CreatorStages
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Add parts
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesParts $parts
     * @return CreatorStages
     */
    public function addPart(\VM\ApiBundle\Entity\CreatorStagesParts $parts)
    {
        $this->parts[] = $parts;
    
        return $this;
    }

    /**
     * Remove parts
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesParts $parts
     */
    public function removePart(\VM\ApiBundle\Entity\CreatorStagesParts $parts)
    {
        $this->parts->removeElement($parts);
    }

    /**
     * Get parts
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getParts()
    {
        return $this->parts;
    }

    /**
     * Add steps
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesSteps $steps
     * @return CreatorStages
     */
    public function addStep(\VM\ApiBundle\Entity\CreatorStagesSteps $steps)
    {
        $this->steps[] = $steps;
    
        return $this;
    }

    /**
     * Remove steps
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesSteps $steps
     */
    public function removeStep(\VM\ApiBundle\Entity\CreatorStagesSteps $steps)
    {
        $this->steps->removeElement($steps);
    }

    /**
     * Get steps
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSteps()
    {
        return $this->steps;
    }

    /**
     * Add creatorStagesCompanyConfirms
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms
     * @return CreatorStages
     */
    public function addCreatorStagesCompanyConfirm(\VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms)
    {
        $this->creatorStagesCompanyConfirms[] = $creatorStagesCompanyConfirms;
    
        return $this;
    }

    /**
     * Remove creatorStagesCompanyConfirms
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms
     */
    public function removeCreatorStagesCompanyConfirm(\VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms)
    {
        $this->creatorStagesCompanyConfirms->removeElement($creatorStagesCompanyConfirms);
    }

    /**
     * Get creatorStagesCompanyConfirms
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCreatorStagesCompanyConfirms()
    {
        return $this->creatorStagesCompanyConfirms;
    }
}